<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Notification;

use Erlage\Photogram\Data\Dtos\Notification\NotificationLinkedContentDTO;

interface InterfaceNotificationSetter
{
    /**
     * @return static 
     */
    public function setId(string $id);

    /**
     * @return static 
     */
    public function setToUserId(string $toUserId);

    /**
     * @return static 
     */
    public function setTargetContentId(string $targetContentId);

    /**
     * @return static 
     */
    public function setLinkedContent(NotificationLinkedContentDTO $linkedContent);

    /**
     * @return static 
     */
    public function setMetaType(string $metaType);

    /**
     * @return static 
     */
    public function setMetaIsRead(string $metaIsRead);

    /**
     * @return static 
     */
    public function setMetaIsTransient(string $metaIsTransient);

    /**
     * @return static 
     */
    public function setStampRegistrationDate(string $stampRegistrationDate);

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration);

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate);
}
